/*	motion.h
 *
 *	Include file for motion.c
 *      Copyright 2000 by Jeroen Vreeken (pe1rxq@amsat.org)
 *      This software is distributed under the GNU public license version 2
 *      See also the file 'COPYING'.
 *
 */

#ifndef _INCLUDE_MOTION_H
#define _INCLUDE_MOTION_H

/* Includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>

#ifdef HAVE_MYSQL
#include <mysql/mysql.h>
#endif

#include <jpeglib.h>

/* Default picture settings */
#define DEF_WIDTH       352
#define DEF_HEIGHT      288
#define DEF_QUALITY     50
#define DEF_CHANGES     1500

#define DEF_MAXFRAMERATE	100
#define DEF_NOISELEVEL	32

/* Minimum time between two 'actions' (email, sms, external) */
#define DEF_GAP         60   /* 1 minutes */
#define DEF_MAXMPEGTIME     3600 /* 60 minutes */


/* date/time drawing, draw.c */
int draw_text (char *image, int startx, int starty, int height, int width, char *text);

struct images {
	unsigned char *new;
	unsigned char *ref;
	unsigned char *out;
	unsigned char *mask;
	int width;
	int height;
};

#endif
