/*
 *  Copyright (C) 2006 Simon Funk - simonfunk@gmail.com
 *  
 *  This program is free software; you can redistribute it and/or modify it under 
 *  the terms of the GNU General Public License as published by the Free Software 
 *  Foundation; either version 2 of the License, or (at your option) any later 
 *  version.
 *  
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY 
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 *  PARTICULAR PURPOSE. See the GNU General Public License for more details.
 */

/*
 * This file is a grossly stripped version of my "Toybox" grab-bag of general utilities,
 *  mostly just whatever was needed by Aparse, which in turn is used by joytouch.
 */


#include "Toybox.h"

File fopen_read(cstring fn)
{
	File fl;

	if (fn == NULL)
		return(stdin);

	if (fl = fopen(fn,"r"))
		return(fl);

	ErFatal1("Can't open file \"%s\" for reading",fn);

	return NULL;
}


/*
 * Returns true if the character 'c'
 * is one of the characters in 's'.
 */
int isoneof(char c,cstring s)
{
	if (!s)
		return 0;

	for (; *s; s++)
		if (*s == c)
			return(1);
	return(0);
}

/*
 * Returns a pointer to the first
 * character after the last '.' in s.
 *
 * Returns pointer to the string "-" if
 * s is NULL.
 */
cstring filename_extension(cstring s)
{
    int i;

    if (s==NULL)
        return("-");

    for (i=strlen(s)-1; i>=0; i--)
        if (s[i] == '.')
            break;
    
    return(s+i+1);
}

